/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.util;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.fw.XMLEncodeable;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProblemDataDescriptor
implements PersistentData,
XMLEncodeable {
    private static final String TRACE_MASKT = "XPAEEDFT";
    private static final String TRACE_MASKF = "XPAEEDFF";
    private static final String TRACE_MASKD = "XPAEEDFD";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String SP_DUMP = "SP_DUMP";
    public static final String SMA_DUMP = "SMA_DUMP";
    public static final String POWER_DUMP = "POWER_DUMP";
    public static final String PLATFORM_DUMP = "PLATFORM_DUMP";
    public static final String FSP_SYSDUMP = "SYSDUMP";
    public static final String FSP_FSPDUMP = "FSPDUMP";
    public static final String FSP_SMADUMP = "SMADUMP";
    public static final String FSP_PWRDUMP = "PWRDUMP";
    public static final String FSP_LOGDUMP = "LOGSYSDUMP";
    public static final String JVM_DUMP = "JVMDUMP";
    public static final String OS_EED = "OS_EED";
    public static final String HPS_EED = "HPS_EED";
    public static final String POWER_EED = "POWER_EED";
    public static final String HMC_EED = "HMC_EED";
    public static final String SYS_EED = "SYS_EED";
    public static final String END_OF_CALL = "END_OF_CALL";
    public static final String PARTITION_MAP = "PARTITION_MAP";
    public static final String INITIAL_CALL_HOME_DATA_SET = "INIT_CALL_HOME_DATA_SET";
    private static final long serialVersionUID = 3997423556139324557L;
    private String name;
    private String fileLocation;
    private boolean calledHome = false;
    private boolean calledHomeCandidate = false;
    private boolean errorDuringCollection = false;

    public boolean equals(Object obj) {
        Trace.trace(TRACE_MASKD, "--> equals()");
        if (obj instanceof ProblemDataDescriptor && this.name.equals(((ProblemDataDescriptor)obj).name)) {
            Trace.trace(TRACE_MASKD, "<-- equals(true)");
            return true;
        }
        Trace.trace(TRACE_MASKD, "<-- equals(false)");
        return false;
    }

    public boolean isInZip() {
        return this.fileLocation.toUpperCase().endsWith("ZIP");
    }

    public void setName(String inputName) {
        this.name = inputName;
    }

    public String getName() {
        return this.name;
    }

    public void setLocation(String inputName) {
        this.fileLocation = inputName;
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public boolean isCalledHome() {
        return this.calledHome;
    }

    public void setCalledHome(boolean flag) {
        this.calledHome = flag;
    }

    public boolean isCallHomeCandidate() {
        return this.calledHomeCandidate;
    }

    public void setCallHomeCandidate(boolean flag) {
        this.calledHomeCandidate = flag;
    }

    public boolean isErrorWhileCollecting() {
        return this.errorDuringCollection;
    }

    public void setErrorWhileCollecting(boolean flag) {
        this.errorDuringCollection = flag;
    }

    public String getType() {
        if (this.name.toUpperCase().startsWith(FSP_SYSDUMP)) {
            return FSP_SYSDUMP;
        }
        if (this.name.toUpperCase().startsWith(FSP_FSPDUMP)) {
            return FSP_FSPDUMP;
        }
        if (this.name.toUpperCase().startsWith(FSP_SMADUMP)) {
            return FSP_SMADUMP;
        }
        if (this.name.toUpperCase().startsWith(FSP_PWRDUMP)) {
            return FSP_PWRDUMP;
        }
        if (this.name.toUpperCase().startsWith("LOGDUMP")) {
            return FSP_LOGDUMP;
        }
        if (this.name.toUpperCase().startsWith("OSE")) {
            return OS_EED;
        }
        if (this.name.toUpperCase().startsWith("SPD")) {
            return SP_DUMP;
        }
        if (this.name.toUpperCase().startsWith("SMA")) {
            return SMA_DUMP;
        }
        if (this.name.toUpperCase().startsWith("POD")) {
            return POWER_DUMP;
        }
        if (this.name.toUpperCase().startsWith("PFD")) {
            return PLATFORM_DUMP;
        }
        if (this.name.toUpperCase().startsWith("HPD")) {
            return HPS_EED;
        }
        if (this.name.toUpperCase().startsWith("POE")) {
            return POWER_EED;
        }
        if (this.name.toUpperCase().startsWith("PMA")) {
            return PARTITION_MAP;
        }
        if (this.name.toUpperCase().startsWith("HMC")) {
            return HMC_EED;
        }
        if (this.name.toUpperCase().startsWith("SYS")) {
            return SYS_EED;
        }
        if (this.name.toUpperCase().startsWith("EOC")) {
            return END_OF_CALL;
        }
        if (this.name.toUpperCase().endsWith("ZIP")) {
            return INITIAL_CALL_HOME_DATA_SET;
        }
        if (this.name.toUpperCase().endsWith("BZ2")) {
            return JVM_DUMP;
        }
        return UNKNOWN;
    }

    public void toXML(StringBuffer sb) {
        sb.append("<ProblemDataDescriptor class=\"" + this.getClass().getName() + "\"");
        if (this.calledHome) {
            sb.append(" calledHome=\"true\"");
        } else {
            sb.append(" calledHome=\"false\"");
        }
        sb.append(" name=\"" + XMLHelper.convertQuote(this.name) + "\"");
        sb.append(" fileLoc=\"" + XMLHelper.convertQuote(this.fileLocation) + "\"");
        sb.append("/>");
    }

    public void fromXML(Node node) {
        Trace.trace(TRACE_MASKD, "--> ProblemDataDescriptor.fromXML");
        NodeList childNodes = node.getChildNodes();
        boolean foundPD = false;
        boolean foundIAL = false;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            String calledHomeString = XMLHelper.getAttributeValue(childNode, "calledHome");
            this.calledHome = calledHomeString != null && calledHomeString.equals("true");
            this.name = XMLHelper.unconvertQuote(XMLHelper.getAttributeValue(childNode, "name"));
            this.fileLocation = XMLHelper.unconvertQuote(XMLHelper.getAttributeValue(childNode, "fileLoc"));
        }
        Trace.trace(TRACE_MASKD, "<-- ProblemDataDescriptor.fromXML");
    }

    public String toString() {
        return "File name=" + this.name + " called home=" + this.calledHome + " location=" + this.fileLocation;
    }

    public static void main(String[] args) {
        try {
            ProblemDataDescriptor pdd = new ProblemDataDescriptor();
            pdd.setCalledHome(true);
            pdd.setLocation("Hawaii");
            pdd.setName("No ka oi!!!!");
            StringBuffer sb = new StringBuffer();
            pdd.toXML(sb);
            Trace.trace(TRACE_MASKD, "sb is" + sb);
            StringBuffer sb2 = new StringBuffer();
            XMLHelper.outToXML(pdd, sb2, pdd.getClass());
            String pasXML = sb2.toString();
            Trace.trace(TRACE_MASKD, "******\nout>>" + pasXML);
            Trace.trace(TRACE_MASKD, "<<out\n******");
            ProblemDataDescriptor rpdd = (ProblemDataDescriptor)XMLHelper.rebuildObject(pasXML, "*");
            Trace.trace(TRACE_MASKD, "rebuilt name " + rpdd.name);
            Trace.trace(TRACE_MASKD, "rebuilt location " + rpdd.fileLocation);
            Trace.trace(TRACE_MASKD, "rebuilt calledhome " + rpdd.calledHome);
            sb = new StringBuffer();
            XMLHelper.outToXML(rpdd, sb, rpdd.getClass());
            String rbXML = sb.toString();
            Trace.trace(TRACE_MASKD, "******\nrebuilt>>" + rbXML);
            Trace.trace(TRACE_MASKD, "<<rebuilt\n******");
            Trace.trace(TRACE_MASKD, "pasXML=rbXML?" + pasXML.equals(rbXML));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "exception");
            Trace.trace(TRACE_MASKD, e);
        }
    }
}

